"""update comments

Revision ID: e3f53a281f1a
Revises: 20916ea34f25
Create Date: 2023-01-23 20:31:50.456873

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "e3f53a281f1a"
down_revision = "20916ea34f25"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "match_report_competitor",
        "id",
        existing_type=sa.INTEGER(),
        comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
    )
    op.alter_column(
        "match_report_competitor",
        "uuid",
        existing_type=postgresql.UUID(),
        comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.alter_column(
        "match_report_stage",
        "id",
        existing_type=sa.INTEGER(),
        comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
        existing_server_default=sa.text("nextval('match_report_stage_id_seq'::regclass)"),
    )
    op.alter_column(
        "match_report_stage",
        "uuid",
        existing_type=postgresql.UUID(),
        comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.alter_column(
        "match_report_stage_score",
        "id",
        existing_type=sa.INTEGER(),
        comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
    )
    op.alter_column(
        "match_report_stage_score",
        "uuid",
        existing_type=postgresql.UUID(),
        comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "match_report_stage_score",
        "uuid",
        existing_type=postgresql.UUID(),
        comment=None,
        existing_comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.alter_column(
        "match_report_stage_score",
        "id",
        existing_type=sa.INTEGER(),
        comment=None,
        existing_comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
    )
    op.alter_column(
        "match_report_stage",
        "uuid",
        existing_type=postgresql.UUID(),
        comment=None,
        existing_comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.alter_column(
        "match_report_stage",
        "id",
        existing_type=sa.INTEGER(),
        comment=None,
        existing_comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
        existing_server_default=sa.text("nextval('match_report_stage_id_seq'::regclass)"),
    )
    op.alter_column(
        "match_report_competitor",
        "uuid",
        existing_type=postgresql.UUID(),
        comment=None,
        existing_comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.alter_column(
        "match_report_competitor",
        "id",
        existing_type=sa.INTEGER(),
        comment=None,
        existing_comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
    )
    # ### end Alembic commands ###
